/********************************************************************

"THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
PURSUANT TO THE 3DFX FXT1 GENERAL PUBLIC LICENSE. A COPY OF THIS
LICENSE MAY BE OBTAINED FROM THE DISTRIBUTOR OR BY CONTACTING 3DFX
INTERACTIVE INC.  

TO THE EXTENT PERMITTED BY APPLICABLE LAW, THERE IS NO WARRANTY FOR
THIS PROGRAM. THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THIS
PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK
AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD
THIS PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
SERVICING, REPAIR OR CORRECTION.

IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, WILL 3DFX INTERACTIVE,
INC., OR ANY OTHER COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY
AND/OR REDISTRIBUTE THIS PROGRAM OR DERIVATIVE WORKS AS PERMITTED
ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE THIS PROGRAM OR DERIVATIVE WORKS (INCLUDING BUT NOT
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES
SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THIS PROGRAM OR
DERIVATIVE WORKS TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH
HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES.

USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
THE UNITED STATES.  COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS
RESERVED"

********************************************************************/

/* 
** ENCOMPPB.C
** 
** 9/02/99 rufus@3dfx.com
** Original release cleanup.
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#ifdef __MSC__
#include <io.h>
#endif
#include <string.h>
#include <math.h>

#include "3dfxpb.h"
#include "fximgpb.h"

#include <assert.h>
#include "comppb.h"

#include "fxt1gpl.h"

int debug = 1; 
FILE *fdebug;
FILE *outf;

/*
 this is the callback mechanism for writing compressed blocks to a file
*/

void fxt1Callback(CCBlock *ccblock, int size)
{
        fwrite(ccblock, size, 1, outf);
}


/*----------------------------------------------------------------------
** MAIN PROGRAM
**----------------------------------------------------------------------
*/
int main(int argc, char **argv)
{
  int n;
  int ppm = 0, output = 1, verbose = 0;
  ImgInfo info;
  CompHeader hd;
  char *program = argv[0]; 


  ForceMethod = -1;
  DisallowMethod = -1;

  for (n = 0; n < 4; n++)
          CFhistogram[n] = 0;

  while (--argc > 0 && **++argv == '-') {
    char *token;
    
    for (token = argv[0] + 1; *token; token++) 
      switch (*token) {
        
      case 'M':
        ForceMethod = 0; /* cc_mixed */
        break;
      case 'H':
        ForceMethod = 1; /* cc_hi */
        break;
      case 'C':
        ForceMethod = 2; /* cc_chroma */
        break;
      case 'A':
        ForceMethod = 3; /* cc_alpha */
        break;
        
      case 'm':
        DisallowMethod = 0; /* cc_mixed */
        break;
      case 'h':
        DisallowMethod = 1; /* cc_hi */
        break;
      case 'c':
        DisallowMethod = 2; /* cc_chroma */
        break;
      case 'a':
        DisallowMethod = 3; /* cc_alpha */
        break;
        
      case 'n':
        output = 0;
        break;
      case 'p':
        ppm = 1;
        break;
      case 'v':
        verbose ++;
        break;
        
      default:
        fprintf (stderr,"%s: illegal option %c\n", program, *token);
        break;
      }
  }
  
  if (argc < 1 || argc > 2) {
    fprintf(stderr, FXT1GPL_TXT);
    fprintf(stderr, "usage: %s [-npv] inimage [outimage]\n",
            program);
    exit(1);
  }
  
  /* read the input image */
  imgReadFile(argv[0], &info);
  
  if (argc < 2) {
    /* no output image, send to stdout */
#ifdef __MSC__
    _setmode( _fileno( stdout ), _O_BINARY);
#endif
    outf = stdout;
  }  else {
    outf = fopen(argv[1], "wb");
    if (!outf) {
      fprintf(stderr, "%s: couldn't open output file %s\n", program, argv[1]);
      exit(1);
    }
  }
  
  if (debug)
    {
      fdebug = fopen("tc3.debug", "wt");
    }
  
  hd.magic = COMP_MAGIC;
  hd.pad = 0;
  hd.width = info.any.width & ~7;
  hd.height = info.any.height & ~3;
  fwrite(&hd, sizeof(hd), 1, outf);
  
  n = encode4x8(&info, fxt1Callback, verbose);
  
  if (verbose) { 
    double invn = 1.0 / n;
    double invNumB = 1.0 / numBlocks;
    
    fprintf(stderr, "RMS = %10.2f PSNR = %10.2f\n",
            totalRMS * invNumB, 10*log10((255*255)/(totalRMS * invNumB)));
    
    fprintf(stderr, "                          %10s %10s %10s %10s\n",
            CFnames[0], CFnames[1], CFnames[2], CFnames[3]);
    
    fprintf(stderr, "CFhistogram             = %10.2f%%%10.2f%%%10.2f%%%10.2f%%\n",
            100.0 * CFhistogram[0] * invNumB,
            100.0 * CFhistogram[1] * invNumB,
            100.0 * CFhistogram[2] * invNumB,
            100.0 * CFhistogram[3] * invNumB
            );
  }
  fclose(outf);
  if (debug) fclose(fdebug);
  free(info.any.data);
  return 0;
}
